/********************************** (C) COPYRIGHT *******************************
* File Name          : USB_HOST.C
* Author             : MJX
* Version            : V1.00
* Date               : 2020/05/15
* Description        : USBغ   										 
*******************************************************************************/



/******************************************************************************/
/* ͷļ */
#include "MAIN.H"	 															/* ͷļ */

/******************************************************************************/
/*  */
UINT8  Com_Buf[ DEF_COM_BUF_LEN ];												/* ͨû */								
UINT8  USBD_DevDesc_Buf[ 18 ];													/* USB豸 */
UINT8  USBD_AllDesc_Buf[ DEF_USBD_DESC_BUF_LEN ];								/* USB豸 */
struct USBD_DESC_INFO USBD_Desc[ 3 ];											/* USB豸Ϣؽṹ */
struct __HOST_CTL HostCtl[ 4 ];      											/* USB豸ؽṹ */                            
                             
UINT8V	USBH_ReadyTimer = 0x00;													/* USB⵽豸ȶʱ */
UINT8V  USBH_ResetTimer = 0x00;													/* USBֱͨ豸λʱ */

UINT8X  HID_SetReport_Last = 0x00;                                              /* USB SetReportֵ(һ) */  
UINT16X Cfg_Desc_Len = 0x0000;                                                  /* USB豸 */

#pragma NOAREGS

/*******************************************************************************
* Function Name  : USBH_AnalyseType
* Description    : 򵥷ǰUSB豸
* Input          : pbuf: ݻ
*				   ptype 豸
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_AnalyseType( UINT8 *pbuf, UINT8 *ptype )  
{	
	UINT8  dv_cls, if_cls;	
	
	dv_cls = ( (PUSB_DEV_DESCR)USBD_DevDesc_Buf )->bDeviceClass;
	if_cls = ( (PUSB_CFG_DESCR_LONG)pbuf )->itf_descr.bInterfaceClass;  
	if( ( dv_cls == USB_DEV_CLASS_STORAGE ) || ( if_cls == USB_DEV_CLASS_STORAGE ) ) 
	{  			
		*ptype = USB_DEV_CLASS_STORAGE;
	}
	else if( ( dv_cls == USB_DEV_CLASS_PRINTER ) || ( if_cls == USB_DEV_CLASS_PRINTER ) ) 
	{  
		*ptype = USB_DEV_CLASS_PRINTER;
	}
	else if( ( dv_cls == USB_DEV_CLASS_HID ) || ( if_cls == USB_DEV_CLASS_HID ) ) 
	{  
		*ptype = USB_DEV_CLASS_HID;	
	}
	else if( ( dv_cls == USB_DEV_CLASS_HUB ) || ( if_cls == USB_DEV_CLASS_HUB ) ) 
	{  
		*ptype = USB_DEV_CLASS_HUB;	
	}	
	else 
	{   
		*ptype = DEV_TYPE_UNKNOW;
	}
}	

/*******************************************************************************
* Function Name  : USBH_HIDDescOff_Change
* Description    : USB HID豸ַƫƸ
* Input          : index: 豸
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_HIDDescOff_Change( UINT8 index )
{
    USBD_Desc[ index ].Dev_Offset = USBD_Desc[ index ].Dev_Offset - USBD_Desc[ index ].Base_Offset;
    USBD_Desc[ index ].Cfg_Offset = USBD_Desc[ index ].Cfg_Offset - USBD_Desc[ index ].Base_Offset;																								
    USBD_Desc[ index ].Hid1_Offset = USBD_Desc[ index ].Hid1_Offset - USBD_Desc[ index ].Base_Offset;																			
    USBD_Desc[ index ].Hid2_Offset = USBD_Desc[ index ].Hid2_Offset - USBD_Desc[ index ].Base_Offset;																								
    USBD_Desc[ index ].Hid3_Offset = USBD_Desc[ index ].Hid3_Offset - USBD_Desc[ index ].Base_Offset;																													
    USBD_Desc[ index ].Hid4_Offset = USBD_Desc[ index ].Hid4_Offset - USBD_Desc[ index ].Base_Offset;																										
    USBD_Desc[ index ].Hid5_Offset = USBD_Desc[ index ].Hid5_Offset - USBD_Desc[ index ].Base_Offset;																													
    USBD_Desc[ index ].Str1_Offset = USBD_Desc[ index ].Str1_Offset - USBD_Desc[ index ].Base_Offset;																			
    USBD_Desc[ index ].Str2_Offset = USBD_Desc[ index ].Str2_Offset - USBD_Desc[ index ].Base_Offset;														
    USBD_Desc[ index ].Str3_Offset = USBD_Desc[ index ].Str3_Offset - USBD_Desc[ index ].Base_Offset;																													
    USBD_Desc[ index ].Str4_Offset = USBD_Desc[ index ].Str4_Offset - USBD_Desc[ index ].Base_Offset;
}

/*******************************************************************************
* Function Name  : USBH_Desc_Base_Offset_Setting
* Description    : USB HID²豸ַ
* Input          : dev_x: ǰ²豸ҪռUSBXеDevX
*				   dev_ydev_z: USBXDevX
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_Desc_Base_Offset_Setting( UINT8 dev_x, UINT8 dev_y, UINT8 dev_z )
{
	if( PCx_DevX_Status[ dev_y ] & BIT_DEV3_IS_PASS )
	{
		/* жdev_y豸 */
		
		if( PCx_DevX_Status[ dev_z ] & BIT_DEV3_IS_PASS )
		{
			/* жdev_z豸Ҳ */
			
			if( ( USBD_Desc[ dev_y ].Base_Offset == ( USBD_Desc[ dev_z ].Base_Offset + USBD_Desc[ dev_z ].Desc_Total ) ) || 
				( USBD_Desc[ dev_z ].Base_Offset == ( USBD_Desc[ dev_y ].Base_Offset + USBD_Desc[ dev_y ].Desc_Total ) )
			  )
			{
				/* жdev_ydev_z豸Ŵ */
				
				if( MIN( USBD_Desc[ dev_y ].Base_Offset, USBD_Desc[ dev_z ].Base_Offset ) != 0 )
				{
					/* жdev_ydev_z豸ĻַСĲΪ0,ǵǰ,ԻַԼĵַӦĸı */
					
					memcpy( &USBD_AllDesc_Buf[ 0 ], &USBD_AllDesc_Buf[ MIN( USBD_Desc[ dev_y ].Base_Offset, USBD_Desc[ dev_z ].Base_Offset ) ], ( USBD_Desc[ dev_y ].Desc_Total + USBD_Desc[ dev_z ].Desc_Total ) );		
					if( USBD_Desc[ dev_y ].Base_Offset < USBD_Desc[ dev_z ].Base_Offset )
					{
                        /* dev_y豸ƫƵַ */
                        USBH_HIDDescOff_Change( dev_y );
                        USBD_Desc[ dev_y ].Base_Offset = 0;
                        
                        /* dev_z豸ƫƵַ */
						USBD_Desc[ dev_z ].Base_Offset = USBD_Desc[ dev_y ].Desc_Total;
                        USBH_HIDDescOff_Change( dev_z );
					}
					else
					{
						/* dev_z豸ƫƵַ */
                        USBH_HIDDescOff_Change( dev_z );
                        USBD_Desc[ dev_z ].Base_Offset = 0;
                        
                        /* dev_y豸ƫƵַ */
						USBD_Desc[ dev_y ].Base_Offset = USBD_Desc[ dev_z ].Desc_Total;
                        USBH_HIDDescOff_Change( dev_y );
					}
				}
			}
			else
			{
				/* dev_ydev_z,һǴڻǰ,жdev_ydev_zĸַ0 */
				
				if( USBD_Desc[ dev_y ].Base_Offset )
				{
					/* dev_zĻַΪ0,dev_yǰ */
					memcpy( &USBD_AllDesc_Buf[ USBD_Desc[ dev_z ].Desc_Total ], &USBD_AllDesc_Buf[ USBD_Desc[ dev_y ].Base_Offset ], USBD_Desc[ dev_y ].Desc_Total );		
                    USBD_Desc[ dev_y ].Base_Offset = USBD_Desc[ dev_z ].Desc_Total;
                    USBH_HIDDescOff_Change( dev_y );
				}
				else
				{
					/* dev_yĻַΪ0,dev_zǰ */
					memcpy( &USBD_AllDesc_Buf[ USBD_Desc[ dev_y ].Desc_Total ], &USBD_AllDesc_Buf[ USBD_Desc[ dev_z ].Base_Offset ], USBD_Desc[ dev_z ].Desc_Total );
                    
                    /* dev_z豸ƫƵַ */
                    USBD_Desc[ dev_z ].Base_Offset = USBD_Desc[ dev_y ].Desc_Total;
                    USBH_HIDDescOff_Change( dev_z );
				}
			}
			
			/* dev_xĻַΪdev_ydev_z֮ */
			USBD_Desc[ dev_x ].Base_Offset = ( USBD_Desc[ dev_y ].Desc_Total + USBD_Desc[ dev_z ].Desc_Total );
		}
		else
		{
			/* dev_z豸 */
			
			if( USBD_Desc[ dev_y ].Base_Offset != 0 )
			{
				/* жdev_yĻַΪ0,dev_y豸ǰ,ַΪ0 */
				memcpy( &USBD_AllDesc_Buf[ 0 ], &USBD_AllDesc_Buf[ USBD_Desc[ dev_y ].Base_Offset ], USBD_Desc[ dev_y ].Desc_Total );
				
                /* dev_y豸ƫƵַ */
                USBH_HIDDescOff_Change( dev_y );
                USBD_Desc[ dev_y ].Base_Offset = 0x0000;
			}
			USBD_Desc[ dev_x ].Base_Offset = USBD_Desc[ dev_y ].Desc_Total;
		}
	}
	else
	{
		/* dev_y豸 */
		
		if( PCx_DevX_Status[ dev_z ] & BIT_DEV3_IS_PASS )
		{
			/* жdev_z豸 */
			
			if( USBD_Desc[ dev_z ].Base_Offset != 0 )
			{
				/* жdev_zĻַΪ0,dev_z豸ǰ,ӦĻַ */
				
				memcpy( &USBD_AllDesc_Buf[ 0 ], &USBD_AllDesc_Buf[ USBD_Desc[ dev_z ].Base_Offset ], USBD_Desc[ dev_z ].Desc_Total );
                
                /* dev_z豸ƫƵַ */
                USBH_HIDDescOff_Change( dev_z );
                USBD_Desc[ dev_z ].Base_Offset = 0x0000;
			}
            
            /* Ҫ洢豸ļַ */
			USBD_Desc[ dev_x ].Base_Offset = USBD_Desc[ dev_z ].Desc_Total;
		}
		else
		{
			/* dev_z豸Ҳ,dev_x豸ĻַΪ0, */		
			USBD_Desc[ dev_x ].Base_Offset = 0x0000;
		}
	}
}

/*******************************************************************************
* Function Name  : USBH_HIDDese_Save
* Description    : USB HID豸
* Input          : index: 豸
*				   type: 
*				   pbuf: ݻ
*				   len ݳ
* Output         : None
* Return         : None
*******************************************************************************/
void USBH_HIDDese_Save( UINT8 index, UINT8 type, UINT8 *pbuf, UINT16 len )
{
	UINT16  offset;

	EA = 0;
	switch( type )
	{
		case 0:
			/* USB豸 */
            switch( index )
            {
                case 0:
                    USBH_Desc_Base_Offset_Setting( 0, 1, 2 );
                    break;
                case 1:
                    USBH_Desc_Base_Offset_Setting( 1, 0, 2 );
                    break;
                case 2:
                    USBH_Desc_Base_Offset_Setting( 2, 0, 1 );
                    break;
                default:
                    break;
            }

			/* ز */
			USBD_Desc[ index ].Desc_Total = 0x00;
			USBD_Desc[ index ].Dev_Offset = 0x00;														
			USBD_Desc[ index ].Dev_Len = 0x00;															
			USBD_Desc[ index ].Cfg_Offset = 0x00;															
			USBD_Desc[ index ].Cfg_Len = 0x00;															
			USBD_Desc[ index ].Hid1_Offset = 0x00;														
			USBD_Desc[ index ].Hid1_Len = 0x00;														
			USBD_Desc[ index ].Hid2_Offset = 0x00;															
			USBD_Desc[ index ].Hid2_Len = 0x00;														
			USBD_Desc[ index ].Hid3_Offset = 0x00;														
			USBD_Desc[ index ].Hid3_Len = 0x00;															
			USBD_Desc[ index ].Hid4_Offset = 0x00;													
			USBD_Desc[ index ].Hid4_Len = 0x00;															
			USBD_Desc[ index ].Hid5_Offset = 0x00;														
			USBD_Desc[ index ].Hid5_Len = 0x00;																
			USBD_Desc[ index ].Str1_Offset = 0x00;														
			USBD_Desc[ index ].Str1_Len = 0x00;														
			USBD_Desc[ index ].Str2_Offset = 0x00;														
			USBD_Desc[ index ].Str2_Len = 0x00;															
			USBD_Desc[ index ].Str3_Offset = 0x00;															
			USBD_Desc[ index ].Str3_Len = 0x00;															
			USBD_Desc[ index ].Str4_Offset = 0x00;														
			USBD_Desc[ index ].Str4_Len = 0x00;								

			/*  */
			if( pbuf[ 7 ] != 0x40  )
			{
				pbuf[ 7 ] = 0x40;	
			}
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Dev_Offset = offset;															
		    USBD_Desc[ index ].Dev_Len = len;												  
			break;

		case 1:
			/* USB */	

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Cfg_Offset = offset;															
		    USBD_Desc[ index ].Cfg_Len = len;
			break;

 		case 2:
			/* USB HID1 */	

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Hid1_Offset = offset;															
		    USBD_Desc[ index ].Hid1_Len = len;													   
			break;

 		case 3:
			/* USB HID2 */

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Hid2_Offset = offset;															
		    USBD_Desc[ index ].Hid2_Len = len;	
			break;
				
 		case 4:
			/* USB HID3 */

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Hid3_Offset = offset;															
		    USBD_Desc[ index ].Hid3_Len = len;
			break;
				
 		case 5:
			/* USB HID4 */

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Hid4_Offset = offset;															
		    USBD_Desc[ index ].Hid4_Len = len;
			break;
				
 		case 6:
			/* USB HID5 */

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Hid5_Offset = offset;															
		    USBD_Desc[ index ].Hid5_Len = len;
			break;
				
 		case 7:
			/* USBַ1 */

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Str1_Offset = offset;															
		    USBD_Desc[ index ].Str1_Len = len;
			break;
				
 		case 8:
			/* USBַ2 */

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Str2_Offset = offset;															
		    USBD_Desc[ index ].Str2_Len = len;				
			break;

 		case 9:
			/* USBַ3 */

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Str3_Offset = offset;															
		    USBD_Desc[ index ].Str3_Len = len;
			break;
				
 		case 10:
			/* USBַ4 */

			/*  */
			offset = USBD_Desc[ index ].Base_Offset + USBD_Desc[ index ].Desc_Total;
		    USBD_Desc[ index ].Str4_Offset = offset;															
		    USBD_Desc[ index ].Str4_Len = len;
			break;

		default:
			break;
	}
	
	/* ǰߵܻ */
	if( ( offset + len ) < DEF_USBD_DESC_BUF_LEN )
	{
		memcpy( &USBD_AllDesc_Buf[ offset ], pbuf, len ); 
	}
	USBD_Desc[ index ].Desc_Total += len;

	EA = 1;
}			

/*****************************************************************************
* Function Name  : USBH_Enum_RootDevice
* Description    : USBöٸ豸
* Input          : index: 豸
*				   mode ģʽ,0: öǰ; 1:öٲ;
* Return         : NO
*******************************************************************************/
UINT8 USBH_Enum_RootDevice( UINT8 index, UINT8 mode ) 
{
	UINT8  cfg;
	UINT8  s;
	UINT8  enum_cnt;
	UINT16 i;

	printf("Enum: %x\n",(UINT16)index );

    /*  */
	if( mode == 0 )
	{
		memset( &HostCtl[ index ].InterfaceNum, 0, sizeof( struct __HOST_CTL ) );
	}
	enum_cnt = 0;
    
ENUM_START:                                    
	/* ʱȴ豸ȶ */
	mDelaymS( 100 );
	enum_cnt++;
	mDelaymS( 8 << enum_cnt ); 

	/* ʼUSB豸öٲ */
	/* λUSB豸,ȴUSB豸 */
	USBH_ResetRootHubPort( index, 0 );   
	for( i = 0, s = 0; i < RE_ATTACH_TIMEOUT; i++ ) 
	{  					
		if( USBH_EnableRootHubPort( index ) == ERR_SUCCESS ) 
		{  
			i = 0;
			s++;  					
			if( s > 6 ) 
			{
				break;  	
			}
		}
		mDelaymS( 1 );
	}
	if( i ) 
	{  
		/* жǷﵽԴ,δﵽ */
		if( enum_cnt <= 5 ) 
		{
			goto ENUM_START;  
		}
		USBH_DisableRootHubPort( index );
		return( ERR_USB_DISCON );		
	}

	/* ѡָROOT-HUB˿ */
	USBH_SelectHubPort( index );  
                                         
	/* ȡUSB豸豸 */
	printf("Get USB Device Descr: ");
	s = USBH_GetDeviceDescr( USBD_DevDesc_Buf );
	printf("s1:%02x\n",(UINT16)s );         
	if( s == ERR_SUCCESS ) 
	{
		/* ӡUSB豸豸 */
		for( i = 0; i < 18; i++ )
		{
			printf("%02x ",(UINT16)USBD_DevDesc_Buf[ i ]);	
		}
		printf("\n");

		/* ˵0ĳ */
		RootHubDev[ index ].bEp0MaxPks = UsbDevEndp0Size; 

		/* USB豸豸 */
	}
	else
	{
		/* жǷﵽԴ,δﵽ */
		if( enum_cnt <= 5 ) 
		{
			goto ENUM_START;  
		}
		return( DEC_DESCR_GETFAIL );
	}

	/* USB豸ַ */
	/* USB豸ַ,RootIndexԱ֤HUB˿ڷ䲻ͬĵַ */
	printf("Set USB Device Address: ");	
	s = USBH_SetUsbAddress( index + ( (PUSB_SETUP_REQ)SetupSetUsbAddr )->wValueL );  	
	printf("s2:%02x\n",(UINT16)s ); 
	if( s == ERR_SUCCESS )
	{
		/* USBַ */
		RootHubDev[ index ].bAddress = index + ( (PUSB_SETUP_REQ)SetupSetUsbAddr )->wValueL;   
	}
	else
	{
		/* жǷﵽԴ,δﵽ */
		if( enum_cnt <= 5 ) 
		{
			goto ENUM_START;  
		} 
		return( DEC_DESCR_GETFAIL );
	}
	mDelaymS( 5 ); 

	/* ȡUSB豸 */
	printf("Get USB Device Cfg Descr: ");
	s = USBH_GetConfigDescr( Com_Buf, &Cfg_Desc_Len ); 
	printf("s3:%02x\n",(UINT16)s ); 
	cfg = ( (PUSB_CFG_DESCR)Com_Buf )->bConfigurationValue;
	if( s == ERR_SUCCESS )
	{
		/* ӡUSB豸 */
		for( i = 0; i < Cfg_Desc_Len; i++ )
		{
			printf("%02x ",(UINT16)Com_Buf[ i ]);	
		}
		printf("\n");
		
		/* 򵥷USB豸 */
		USBH_AnalyseType( Com_Buf, &RootHubDev[ index ].bType );
		printf("RootDev.bType: %02x\n",(UINT16)RootHubDev[ index ].bType );
	}
	else
	{
		/* жǷﵽԴ,δﵽ */
		if( enum_cnt <= 5 ) 
		{
			goto ENUM_START;  
		}
		return( DEC_DESCR_GETFAIL );
	}

	/* USB豸ֵ */
	printf("Set USB Cfg: ");
	s = USBH_SetUsbConfig( cfg );  
	printf("s4:%02x\n",(UINT16)s ); 
	if( s != ERR_SUCCESS )
	{
		/* жǷﵽԴ,δﵽ */
		if( enum_cnt <= 5 ) 
		{
			goto ENUM_START;  
		}
		return( ERR_USB_UNSUPPORT );
	} 	

	return( ERR_SUCCESS );
}

/*****************************************************************************
* Function Name  : USBH_Enum_HidDevice
* Description    : USBöHID豸
* Input          : NO
* Return         : NO
*******************************************************************************/
UINT8 USBH_Enum_HidDevice( UINT8 portnum, UINT8 dev ) 
{
	UINT8  s;
	UINT8  i, j;

	printf("Enum_Hid:%02x\n",(UINT16)portnum ); 
	
	/* USB豸ӿϢ */
	HostCtl[ portnum ].InterfaceNum = 0;
	for( i = 0; i < DEF_INTERFACE_NUM_MAX; i++ )
	{
		HostCtl[ portnum ].Interface[ i ].Type = 0;  
		HostCtl[ portnum ].Interface[ i ].HidReportID = 0;       												
		HostCtl[ portnum ].Interface[ i ].HidDescLen = 0;  
		HostCtl[ portnum ].Interface[ i ].InEndpNum = 0;
		HostCtl[ portnum ].Interface[ i ].OutEndpNum = 0;
		for( j = 0; j < 4; j++ )
		{
			HostCtl[ portnum ].Interface[ i ].InEndpAddr[ j ] = 0; 
			HostCtl[ portnum ].Interface[ i ].InEndpType[ j ] = 0; 
			HostCtl[ portnum ].Interface[ i ].InEndpSize[ j ] = 0;
			HostCtl[ portnum ].Interface[ i ].InEndpTog[ j ] = 0;
		   	HostCtl[ portnum ].Interface[ i ].InEndpInterval[ j ] = 0;
			HostCtl[ portnum ].Interface[ i ].InEndpTimeCount[ j ] = 0;
	
			HostCtl[ portnum ].Interface[ i ].OutEndpAddr[ j ] = 0;
			HostCtl[ portnum ].Interface[ i ].OutEndpType[ j ] = 0;
			HostCtl[ portnum ].Interface[ i ].OutEndpSize[ j ] = 0;
			HostCtl[ portnum ].Interface[ i ].OutEndpTog[ j ] = 0;			
		}			
	}	
	
	/* HID豸USB,ز */
	printf("Analyse_ConfigDesc: ");
	s = KM_Analyse_ConfigDesc( portnum );
	printf("ss1:%02x\n",(UINT16)s );
	if( s != DEC_SUCCESS )
	{
		return( s );
	}
	
	/* ȡHID */
	printf("Hid Descr Analyse: ");
    s = KM_Deal_HidReportDesc( portnum, dev );
	printf("ss2:%02x\n",(UINT16)s );
  
	/* ȡַ */
	if( USBD_DevDesc_Buf[ 14 ] )		
	{
		/* ȡUSBַ */
		printf("Get USB String Descr1: ");
		s = USBH_GetStrDescr( USBD_DevDesc_Buf[ 14 ], Com_Buf );
		printf("ss3:%02x\n",(UINT16)s );
		if( s == ERR_SUCCESS ) 
		{
			/* ӡUSBַ */
			for( i = 0; i < Com_Buf[ 0 ]; i++ )
			{
				printf("%02x ",(UINT16)Com_Buf[ i ]);	
			}
			printf("\n");
	
            /* USBַ */
        #if ( DEF_USE_USBX == 0x01 )
			USBH_HIDDese_Save( dev, 7, Com_Buf, Com_Buf[ 0 ] );
        #endif    
		}
	}
    
	if( USBD_DevDesc_Buf[ 15 ] )		
	{
		/* ȡUSBƷַ */
		printf("Get USB String Descr2: ");
		s = USBH_GetStrDescr( USBD_DevDesc_Buf[ 15 ], Com_Buf );
		printf("ss4:%02x\n",(UINT16)s );
		if( s == ERR_SUCCESS ) 
		{
			/* ӡUSB豸豸 */
			for( i = 0; i < Com_Buf[ 0 ]; i++ )
			{
				printf("%02x ",(UINT16)Com_Buf[ i ]);	
			}
			printf("\n");

            /* Ʒַ */
		#if ( DEF_USE_USBX == 0x01 )
            USBH_HIDDese_Save( dev, 8, Com_Buf, Com_Buf[ 0 ] );
        #endif            
		}				
	}
    
	if( USBD_DevDesc_Buf[ 16 ] )		
	{
		/* ȡUSBкַ */
		printf("Get USB String Descr3: ");
		s = USBH_GetStrDescr( USBD_DevDesc_Buf[ 16 ], Com_Buf );
		printf("ss5:%02x\n",(UINT16)s );
		if( s == ERR_SUCCESS ) 
		{
			/* ӡUSB豸豸 */
			for( i = 0; i < Com_Buf[ 0 ]; i++ )
			{
				printf("%02x ",(UINT16)Com_Buf[ i ]);	
			}
			printf("\n");
			
            /* Ʒַ */
        #if ( DEF_USE_USBX == 0x01 )
            USBH_HIDDese_Save( dev, 9, Com_Buf, Com_Buf[ 0 ] );
        #endif
		}		
	}

	if( USBD_AllDesc_Buf[ USBD_Desc[ dev ].Cfg_Offset + 6 ] )		
	{
		/* ȡаַ */
		printf("Get USB String Descr4: ");
		s = USBH_GetStrDescr( USBD_AllDesc_Buf[ USBD_Desc[ dev ].Cfg_Offset + 6 ], Com_Buf );	 
		printf("ss6:%02x\n",(UINT16)s );
		if( s == ERR_SUCCESS ) 
		{
			/* ӡUSB豸豸 */
			for( i = 0; i < Com_Buf[ 0 ]; i++ )
			{
				printf("%02x ",(UINT16)Com_Buf[ i ]);	
			}
			printf("\n");
			
            /* Ʒַ */
        #if ( DEF_USE_USBX == 0x01 )
            USBH_HIDDese_Save( dev, 10, Com_Buf, Com_Buf[ 0 ] );
		#endif
		}			
	}

	return( ERR_SUCCESS );
}	

/*******************************************************************************
* Function Name  : USBH_Analyse_CfgDesc
* Description    : USBµ豸
* Input          : index: 豸
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_Analyse_CfgDesc( UINT8 index )  
{
	UINT8  intfacenum, innum, outnum;
    UINT16 i, j;
    UINT16 total_len;

	/* 浱ǰUSB豸Ľӿ */
	if( ( (PUSB_CFG_DESCR)( &Com_Buf[ 0 ] ) )->bNumInterfaces > DEF_INTERFACE_NUM_MAX )
	{
		HostCtl[ index ].InterfaceNum = DEF_INTERFACE_NUM_MAX;
	}
	else
	{	 
		HostCtl[ index ].InterfaceNum = ( (PUSB_CFG_DESCR)( &Com_Buf[ 0 ] ) )->bNumInterfaces;
	}
            
	/* 豸˵ */
    total_len = Com_Buf[ 2 ] + ((UINT16)Com_Buf[ 3 ] << 8 );
	intfacenum = 0;	      
	for( i = 0; i < total_len; i++ ) 
	{	
		if( ( Com_Buf[ i + 0 ] == 0x09 ) && 
		    ( Com_Buf[ i + 1 ] == 0x04 ) &&
            ( Com_Buf[ i + 2 ] == intfacenum ) )
		{
			/* ǰӿ */
            innum = 0;  
            outnum = 0;    
            i += 9;
			for( j = 0; j < total_len - i; j++ ) 
			{	      
				if( ( Com_Buf[ i + j + 0 ] == 0x09 ) && 
				    ( Com_Buf[ i + j + 1 ] == 0x21 ) && 
                    ( Com_Buf[ i + j + 6 ] == 0x22 ) )  
                {
                    HostCtl[ index ].Interface[ intfacenum ].HidDescLen = Com_Buf[ i + j + 7 ] + ((UINT16)Com_Buf[ i + j + 8 ] << 8 );
                }
				else if( ( Com_Buf[ i + j + 0 ] == 0x07 ) && 
				         ( Com_Buf[ i + j + 1 ] == 0x05 ) )  
				{           	       
					if( ( Com_Buf[ i + j + 2 ] & 0x80 ) == 0x00 )    			    			
					{
                        /* OUT˵ */
                        if( outnum < 4 )
                        {                            
                            HostCtl[ index ].Interface[ intfacenum ].OutEndpAddr[ outnum ] = Com_Buf[ i + j + 2 ];                       
                            HostCtl[ index ].Interface[ intfacenum ].OutEndpType[ outnum ] = Com_Buf[ i + j + 3 ];   
                            HostCtl[ index ].Interface[ intfacenum ].OutEndpSize[ outnum ] = Com_Buf[ i + j + 4 ];
                            HostCtl[ index ].Interface[ intfacenum ].OutEndpTog[ outnum ] = 0x00;  
                            outnum++;
                            HostCtl[ index ].Interface[ intfacenum ].OutEndpNum = outnum;                            
                        }                                  
				    }
					else                             							
					{
                        /* IN˵ */
                        if( innum < 4 )
                        {    
                            HostCtl[ index ].Interface[ intfacenum ].InEndpAddr[ innum ] = Com_Buf[ i + j + 2 ];       											
                            HostCtl[ index ].Interface[ intfacenum ].InEndpType[ innum ] = Com_Buf[ i + j + 3 ];
                            HostCtl[ index ].Interface[ intfacenum ].InEndpSize[ innum ] = Com_Buf[ i + j + 4 ];        
                            HostCtl[ index ].Interface[ intfacenum ].InEndpInterval[ innum ] = Com_Buf[ i + j + 6 ];
							if(  HostCtl[ index ].Interface[ intfacenum ].InEndpInterval[ innum ] == 0 )
							{
								 HostCtl[ index ].Interface[ intfacenum ].InEndpInterval[ innum ] = 0;
							}								
                            HostCtl[ index ].Interface[ intfacenum ].InEndpTog[ innum ] = 0x00;         										    
                            HostCtl[ index ].Interface[ intfacenum ].InEndpTimeCount[ innum ] = 0x00;
                            innum++; 
                            HostCtl[ index ].Interface[ intfacenum ].InEndpNum = innum;        
                        }            
					}    	
				}
				else if( ( Com_Buf[ i + j + 0 ] == 0x09 ) && 
				         ( Com_Buf[ i + j + 1 ] == 0x04 ) )
                {
                    intfacenum++;                   
                    break;
                }                    
			}                  
            if( intfacenum >= 4 )
            {
                break;
            }                
		}
	}    
	return( 0x00 );
}      

/*******************************************************************************
* Function Name  : KM_Analyse_ConfigDesc
* Description    : USB
* Input          : index: 豸
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 KM_Analyse_ConfigDesc( UINT8 index )  
{
	UINT8  s = 0;
	UINT16 i;
	UINT8  num;
	UINT8  IN_count = 0;
    UINT8  OUT_count = 0;

	num = 0;	  
	for( i = 0; i < Com_Buf[ 2 ]; )
	{
		if( Com_Buf[ i + 1 ] == DEF_DECR_CONFIG )
		{
			/* 浱ǰUSB豸Ľӿ */
			if( ( (PUSB_CFG_DESCR)( &Com_Buf[ i ] ) )->bNumInterfaces > DEF_INTERFACE_NUM_MAX )
			{
				HostCtl[index].InterfaceNum = DEF_INTERFACE_NUM_MAX;
			}
			else
			{	 
				HostCtl[index].InterfaceNum = ( (PUSB_CFG_DESCR)( &Com_Buf[ i ] ) )->bNumInterfaces;
			}
			i += Com_Buf[ i ];
		}
		else if( Com_Buf[ i + 1 ] == DEF_DECR_INTERFACE )
		{
			if( num == DEF_INTERFACE_NUM_MAX ) 
			{
				return( s );
			}
			if( ( (PUSB_ITF_DESCR)( &Com_Buf[ i ] ) )->bInterfaceClass == 0x03 )
			{
				/* HID豸(USB) */
				if( ( (PUSB_ITF_DESCR)( &Com_Buf[ i ] ) )->bInterfaceSubClass <= 0x01 && 
					( (PUSB_ITF_DESCR)( &Com_Buf[ i ] ) )->bInterfaceProtocol <= 2 )
				{    
					if( ( (PUSB_ITF_DESCR)( &Com_Buf[ i ] ) )->bInterfaceProtocol == 0x01 )
					{
						/* õǰӿΪUSB */
						HostCtl[ index ].Interface[ num ].Type = DEC_KEY;
                        HID_SetIdleSpeed( 0, num );
					}
                    else if( ( (PUSB_ITF_DESCR)( &Com_Buf[ i ] ) )->bInterfaceProtocol == 0x02 )
					{
						/* õǰӿΪUSB */
						HostCtl[ index ].Interface[ num ].Type = DEC_MOUSE;
                        HID_SetIdleSpeed( 0, num );
					}
					s = DEC_SUCCESS;
					i += Com_Buf[ i ];
					IN_count = 0;
                    OUT_count = 0;
					while( 1 )
					{
						if( ( Com_Buf[ i + 1 ] == DEF_DECR_INTERFACE ) || ( i >= Com_Buf[ 2 ] ) )
						{
							break;
						}
						else
						{
							/* ǰӿµĸ˵ */
							if( Com_Buf[ i + 1 ] == DEF_DECR_ENDPOINT )
							{
								/* ˵Ϣ(˵ַѯʱ) */
								if( ( (PUSB_ENDP_DESCR)( &Com_Buf[ i ] ) )->bEndpointAddress & 0x80 )
								{   
									/* ˵ */
									HostCtl[ index ].Interface[ num ].InEndpAddr[ IN_count ] = ( (PUSB_ENDP_DESCR)( &Com_Buf[ i ] ) )->bEndpointAddress & 0x0f;
                                    HostCtl[ index ].Interface[ num ].InEndpType[ IN_count ] = ( (PUSB_ENDP_DESCR)( &Com_Buf[ i ] ) )->bmAttributes;
									HostCtl[ index ].Interface[ num ].InEndpSize[ IN_count ] = ( (PUSB_ENDP_DESCR)( &Com_Buf[ i ] ) )->wMaxPacketSizeL;
									HostCtl[ index ].Interface[ num ].InEndpNum++;
								}
								else
								{
									/* ˵ */
									HostCtl[ index ].Interface[ num ].OutEndpAddr[ OUT_count ] = ( (PUSB_ENDP_DESCR)( &Com_Buf[ i ] ) )->bEndpointAddress & 0x0f;
									HostCtl[ index ].Interface[ num ].OutEndpType[ OUT_count ] = ( (PUSB_ENDP_DESCR)( &Com_Buf[ i ] ) )->bmAttributes;
									HostCtl[ index ].Interface[ num ].OutEndpSize[ OUT_count ] = ( (PUSB_ENDP_DESCR)( &Com_Buf[ i ] ) )->wMaxPacketSizeL;
									HostCtl[ index ].Interface[ num ].OutEndpNum++;
								}

								HostCtl[ index ].Interface[ num ].InEndpInterval[ IN_count ] = ( (PUSB_ENDP_DESCR)( &Com_Buf[ i ] ) )->bInterval;
								if( HostCtl[ index ].Interface[ num ].InEndpInterval[ IN_count] < 4 ) 
								{
									HostCtl[ index ].Interface[ num ].InEndpInterval[ IN_count ] = 2;
								}
								else if( HostCtl[ index ].Interface[ num ].InEndpInterval[ IN_count ] < 8 ) 
								{
									HostCtl[ index ].Interface[ num ].InEndpInterval[ IN_count ] = 4;
								}
								else if( HostCtl[ index ].Interface[ num ].InEndpInterval[ IN_count ] < 16 ) 
								{
									HostCtl[index].Interface[ num ].InEndpInterval[ IN_count ] = 8;
								}
								else if( HostCtl[ index ].Interface[ num ].InEndpInterval[ IN_count ] == 0 ) 
								{
									HostCtl[ index ].Interface[ num ].InEndpInterval[ IN_count ] = 0;
								}									
								i += Com_Buf[ i ];
                                
                                if( ( (PUSB_ENDP_DESCR)( &Com_Buf[ i ] ) )->bEndpointAddress & 0x80 )
                                {
                                    IN_count++;
                                }
                                else
                                {
                                    OUT_count++;
                                } 
							}
							else if( Com_Buf[ i + 1 ] == DEF_DECR_HID )
							{
								/* 浱ǰӿHID */
								HostCtl[ index ].Interface[ num ].HidDescLen = ( (PUSB_HID_DESCR)( &Com_Buf[ i ] ) )->wDescriptorLengthL | \
																			   ((UINT16)( ( (PUSB_HID_DESCR)( &Com_Buf[ i ] ) )->wDescriptorLengthH ) << 8 );	/* hid len */
								i += Com_Buf[ i ];
							}
							else
							{
								i += Com_Buf[ i ];
							}
						}
					}
				}
				else
				{
					HostCtl[ index ].Interface[ num ].Type = DEC_UNKNOW;
					i += Com_Buf[ i ];
				}
			}
			else
			{
				/* USB豸δ֪ */
				HostCtl[ index ].Interface[ num ].Type = DEC_UNKNOW;
				i += Com_Buf[ i ];
				
				/* ձ׼USB豸 */
				USBH_Analyse_CfgDesc( index );  
				break;
			}
			num++;
		}
		else
		{
			i += Com_Buf[ i ];
		}
	}
	return( s );
}		

/*******************************************************************************
* Function Name  : KM_Deal_HidReportDesc
* Description    : ȡHID
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 KM_Deal_HidReportDesc( UINT8 index, UINT8 dev )  
{
	UINT8  s;
	UINT8  num, num_tmp;    
	UINT16 i;
			  
	num_tmp = HostCtl[ index ].InterfaceNum;
	while( num_tmp )
	{
		num	= HostCtl[ index ].InterfaceNum - num_tmp;
		if( HostCtl[ index ].Interface[ num ].HidDescLen )
		{
			/* ȡHID */
			printf("Get Hid Descr\n");
			s = HID_GetHidDesr( num, Com_Buf, HostCtl[ index ].Interface[ num ].HidDescLen );
			printf("s6: %02x\n",(UINT16)s ); 
            
			if( s == ERR_SUCCESS )
			{
				/* ӡUSB豸 */
				printf("HostCtl[ index ].Interface[ num ].HidDescLen: %02x\n",(UINT16)HostCtl[ index ].Interface[ num ].HidDescLen ); 
				for( i = 0; i < HostCtl[ index ].Interface[ num ].HidDescLen; i++ )
				{
					printf("%02x ",(UINT16)Com_Buf[ i ]);	
				}
				printf("\n");
                
				/* HID */
				USBH_HIDDese_Save( dev, 2 + num, Com_Buf, HostCtl[ index ].Interface[ num ].HidDescLen );
							
				num_tmp--;
			}
			else
			{
				return( DEC_DESCR_GETFAIL ); 
			}
		}
		else
		{
			num_tmp--;
		}		
	}
  
	return( s );
}

/*******************************************************************************
* Function Name  : KM_HostSetReport
* Description    : USBUSB̷SetReport
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 KM_HostSetReport( UINT8 report )
{	
	UINT8  i, len;
	UINT8  dat[ 2 ];
	UINT8  index;
	UINT8  status;
	 
	for( index = 0; index < TOTAL_ROOT_HUB; index++ )
	{
		/* жǷҪUSB豸Xݻȡ */	 
		if( ( RootHubDev[ index ].bStatus >= ROOT_DEV_SUCCESS ) && 
		    ( RootHubDev[ index ].DeviceIndex != 3 ) )
		{
			/* ѡָROOT-HUB˿ */ 
			USBH_SelectHubPort( index );  			

			/* Լ̽ӿڽеƴ */
			for( i = 0; i < HostCtl[ index ].InterfaceNum; i++ )
			{
				/* жϵǰUSB豸ӿǷUSB */
				if( HostCtl[ index ].Interface[ i ].Type == DEC_KEY )
				{
					/* жǷREPORT ID */
					if( HostCtl[ index ].Interface[ i ].HidReportID )
					{
						dat[ 0 ] = HostCtl[ index ].Interface[ i ].HidReportID;
						dat[ 1 ] = report;
						len = 2;
					}
					else
					{
						dat[ 0 ] = report;
						len = 1;
					}			
					
					/* жͨͨʽ,ͨⷽʽ(´˵) */
					/* SetReport */
					if( HostCtl[ index ].Interface[ i ].NoSetReport_Flag == 0x00 )
					{
						status = HID_SetReport( dat, len, i );
					
						/* жǷִгɹ,ʧڲִиò */
						if( status != ERR_SUCCESS )
						{
							HostCtl[ index ].Interface[ i ].NoSetReport_Flag = 0x01;

							/* ¶Ը豸ö,ٴ˵ */
							RootHubDev[ index ].bStatus = ROOT_DEV_CONNECTED;
							status = USBH_Enum_RootDevice( index, 1 );
							if( status == ERR_SUCCESS )
							{
								/* Եǰ豸HIDö */
								status = USBH_Enum_HidDevice( index, RootHubDev[ index ].DeviceIndex );

								/* ñ־ */
								HostCtl[ index ].ErrorCount = 0x00;	
								RootHubDev[ index ].bStatus = ROOT_DEV_SUCCESS;			
							}
						}
					}
					break;
				}
			}						

		}
 	}
	return( 0x01 );
}		

/*******************************************************************************
* Function Name  : USBH_Get_HidData
* Description    : USBȡUSB HID豸	
* Input          : index: 豸
*			       intfnum: ӿ
*			       endpnum: ˵
*				   pbuf: ݻ
*				   plen: ݳ
* Output         : None
* Return         : None
*******************************************************************************/
UINT8 USBH_Get_HidData( UINT8 index, UINT8 intfnum, UINT8 endpnum, UINT8 *pbuf, UINT8 *plen )
{
	UINT16 len;
	UINT8  status;
	UINT8  *p;

	/* ͻȡ˵ */
	status = USBH_Transact( ( USB_PID_IN << 4 ) | HostCtl[ index ].Interface[ intfnum ].InEndpAddr[ endpnum ], HostCtl[ index ].Interface[ intfnum ].InEndpTog[ endpnum ], 0 );       	
	if( status == ERR_SUCCESS )
    {		
		HostCtl[ index ].Interface[ intfnum ].InEndpTog[ endpnum ] ^= bUH_R_TOG | bUH_T_TOG;			
		len = USB_RX_LEN;
		memcpy( pbuf, RxBuffer, len );
		*plen = len; 

		/* ӡǰȡUSBݰ */
		p = pbuf;	
#if 0
		for( i = 0; i < len; i++ )
		{
			printf("%02x ",(UINT16)*p++ );
		}
		printf("\n");	
#endif
	}
	else if( status == ERR_USB_DISCON )
	{
		/* USB豸¼ */
		printf("USB Out2\n");
		
		/* жϵǰǷHUB豸γ */
		if( RootHubDev[ index ].bType == USB_DEV_CLASS_HID )	
		{
			/* ڹرжϺΪUSBXϴHUBж֪ͨ */
			USBX_AllHub_EP1IntUp( RootHubDev[ index ].DeviceIndex, BIT_PORT_C_CONN );  
		
			/* ر */
            PCx_DevX_Status[ RootHubDev[ index ].DeviceIndex ] = 0x00;            
			RootHubDev[ index ].DeviceIndex = 0xFF;
			RootHubDev[ index ].bStatus = 0x00;
			USBH_DisableRootHubPort( index );
             
		}
		else
		{
			printf("HUB Out2\n");
		}
	}
	else if( status == ( USB_PID_STALL | ERR_USB_TRANSFER ) )
	{
		/* USB豸쳣¼ */
		printf("Error1\n");
	   	
		/* ˵ */
		USBH_ClearEndpStall( HostCtl[ index ].Interface[ intfnum ].InEndpAddr[ endpnum ] | 0x80 );
		HostCtl[ index ].Interface[ intfnum ].InEndpTog[ endpnum ] = 0x00;
		
		/* жϳ */
		HostCtl[ index ].ErrorCount++;
		if( HostCtl[ index ].ErrorCount >= 10 )
		{
			/* ¶Ը豸ö,ٴ˵ */
			RootHubDev[ index ].bStatus = ROOT_DEV_CONNECTED;
			status = USBH_Enum_RootDevice( index, 1 );
			if( status == ERR_SUCCESS )
			{
				USBH_ClearEndpStall( HostCtl[ index ].Interface[ intfnum ].InEndpAddr[ endpnum ] | 0x80 );
				HostCtl[ index ].ErrorCount = 0x00;	
				RootHubDev[ index ].bStatus = ROOT_DEV_SUCCESS;	
				
				/* Եǰ豸HIDö */
				status = USBH_Enum_HidDevice( index, RootHubDev[ index ].DeviceIndex );		
			}
		}		
	}
	return( status );
}

/*******************************************************************************
* Function Name  : USBH_Main_Deal
* Description    : USB
* Input          : None
* Output         : None
* Return         : OPERATE_ERRORʾʧ;OPERATE_SUCCESSɹ
*******************************************************************************/ 
UINT8 USBH_Main_Deal( void )
{
    UINT8  s;
	UINT8  index;
	UINT8  num;
	UINT8  i, j;
	UINT8  len;
	UINT8  status;
	UINT8  dev_num;

	/* USB豸μ */
	if( UIF_DETECT ) 
	{  
		UIF_DETECT = 0;  														/* жϱ־ */

		/* ɨROOT-HUB״̬,ROOT-HUB˿ڵ豸¼ */
		for( index = 0; index < TOTAL_ROOT_HUB; index++ ) 
		{
			s = RootHubDev[ index ].bStatus;
			mDelaymS( 3 );
			if( USB_HUB_ST & ( bUHS_H0_ATTACH << index ) ) 
			{  	
				/* 豸 bUHS_H?_ATTACH */

				/* ǰֱͨ豸,ֱͨ򲻴 */
				if( ( RootHubDev[ index ].DeviceIndex == 3 ) && ( PCx_Dev3_Status & BIT_DEV3_IS_PASS ) )
				{
			   		continue;
				}

				/* ⵱ǰ豸ǷҪд */
				if( s == ROOT_DEV_DISCONNECT || s != ROOT_DEV_FAILED && USBH_Check_RootHubStatus( index ) == 0x00 ) 
				{  
					printf( "H%d In\n", (UINT16)index );			
					if( ( RootHubDev[ index ].bStatus == ROOT_DEV_SUCCESS ) ||	
						( RootHubDev[ index ].DeviceIndex == 3  )  )
					{
						continue;	
					}
			
					/* ⵽豸,δ,˵Ǹղ,ųöʧܶرյ豸 */
					USBH_DisableRootHubPort( index );  							/* رն˿ */
					RootHubDev[ index ].bSpeed = USB_HUB_ST & ( bUHS_HM0_LEVEL << index ) ? 0 : 1;  /* bUHS_H?M_LEVEL: 1->/ȫ;0-> */
                    RootHubDev[ index ].bStatus = ROOT_DEV_CONNECTED;  			/* ӱ־ */
					mDelaymS( 1 );	

					/* Ը豸гö */
					IE_USBX = 0;
					s = USBH_Enum_RootDevice( index, 0 );
					IE_USBX = 1;
					printf("s:%x\n",(UINT16)s);
					
                    if( s == ERR_SUCCESS )
					{
						/* öٳɹ */
                        
                        if( RootHubDev[ index ].bType == USB_DEV_CLASS_HID )
						{
							/* ǰ豸ΪHID豸 */
                            printf("Root Device is HID\n");
                            													
                        #if ( DEF_USE_USBX == 0x01 )                           
                            /* жϵǰǷDev */
							for( dev_num = 0; dev_num < 3; dev_num++ )
							{
								if( PCx_DevX_Status[ dev_num ] & BIT_DEV3_IS_PASS )
								{
									/* ǰDev[ dev_num ]ʹ,жһDev[ dev_num+1 ] */
									continue;
								}
								else
								{
									/* ǰDev[ dev_num ] */
									break;
								}
							}					
							                            
							if( dev_num >= 3 )
							{	
								/* ǰDev0-2Ѿȫʹ, жֱͨǷ */
                                
                                if( ( RootHubDev[ index ].bSpeed ) && ( ( PCx_Dev3_Status & BIT_DEV3_IS_PASS ) == 0 ) )
								{
									/* жϵǰ豸ΪUSB/ȫ豸,ֱͨδʹ */
									s = 1;
								}
								
								if( s )
								{
									/* ǰ豸Ϊֱͨ */
									goto PASS_THROUGH;
								}
								else
								{
									/* ֱͨڱռûֱͨڵ豸Ϊ豸,򽫵ǰڲ豸״̬Ϊ */
									RootHubDev[ index ].DeviceIndex = 0xFF;
									RootHubDev[ index ].bStatus = ROOT_DEV_FAILED;
									continue;
								}	
							}
							else
							{
								/* Dev[ i ],򱣴浱ǰ豸豸 */  
								USBH_HIDDese_Save( dev_num, 0, USBD_DevDesc_Buf, 18 );
								USBH_HIDDese_Save( dev_num, 1, Com_Buf, Cfg_Desc_Len );   
							}
                        #else
                            dev_num = index; 
                        #endif                            
                             
                            /* Եǰ豸HIDö */
							IE_USBX = 0;
							s = USBH_Enum_HidDevice( index, dev_num );
							IE_USBX = 1;
							printf("s:%x\n",(UINT16)s);	
                                 
							if( s == ERR_SUCCESS )
							{
                                /* ø豸״̬ */ 
                                RootHubDev[ index ].DeviceIndex = dev_num;
                                PCx_DevX_Status[ dev_num ] = BIT_DEV3_IS_PASS | index;
								RootHubDev[ index ].bStatus = ROOT_DEV_SUCCESS;
								USBH_SetSelfSpeed( 1 );  						/* ĬΪȫ */
								HID_SetReport_Last = 0xFF;
								
                                #if ( DEF_USE_USBX == 0x01 )                                
								/* õԶ˿ڴ״̬ */
								for( i = 0; i < PCx_NumMax; i++ )
								{
									/* õԶ˿ж־ */
									PCx_TaskStatus[ i ] |= ( 1 << ( RootHubDev[ index ].DeviceIndex ) );
									
									/* õԶ˿ӱ־ */
									EA = 0;  					
									USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | i;			  
									X0DevBitFlag[ RootHubDev[ index ].DeviceIndex ] = BIT_PORT_CONNECT | BIT_PORT_C_CONN;
									USBX_SEL = 0;
									EA = 1;

									/* ʼӦUSB豸 */
									USBX_Devx_Endp_Init( i, RootHubDev[ index ].DeviceIndex, index );      
								}
                                #endif
							}
						}
						else
						{
							/* ǰ豸ΪHID豸 */
                            printf("Root Device is Non-HID\n");
                            RootHubDev[ index ].DeviceIndex = index;
                            RootHubDev[ index ].bStatus = ROOT_DEV_SUCCESS;
                            RootHubDev[ index ].bSpeed = 1;
                            
                            #if ( DEF_USE_USBX == 0x01 )
                            if( ( RootHubDev[ index ].bSpeed ) && ( ( PCx_Dev3_Status & BIT_DEV3_IS_PASS ) == 0 ) )
							{
								/* Ϊֱͨ豸 */
PASS_THROUGH:
								mDelaymS( 1 );			
								printf("PCx_PassUSB_ActionNum:%x\n",(UINT16)PCx_PassUSB_ActionNum);
								RootHubDev[ index ].DeviceIndex = 3;
								RootHubDev[ index ].bStatus = ROOT_DEV_SUCCESS;			
								USBH_ResetRootHubPort( index, 0 );  				/* λӦ˿ڵUSB */
								PCx_Dev3_Status = BIT_DEV3_IS_PASS | index;  		/* Ϊֱͨ豸 */
								UH_THROUGH = ( ( PCx_Dev3_Status & BIT_DEV3_ROOT_IDX ) << 2 ) | PCx_PassUSB_ActionNum & MASK_UH_THR_UX;
								USB_CTRL &= ~bUC_THROUGH;  							/* USBֱֹͨ */							
								USBX_OneHub_EP1IntUp( PCx_PassUSB_ActionNum, 3, BIT_PORT_CONNECT | BIT_PORT_C_CONN );	  							
								USBH_SetSelfSpeed( 1 );  							/* ĬΪȫ */
							}
                            #endif
						}
					} 
					else
					{
						/* öʧ,óֱͨ */
						printf("Enum_Err:%x\n",(UINT16)s);
                        RootHubDev[ index ].DeviceIndex = 0xFF;
                        RootHubDev[ index ].bStatus = ROOT_DEV_FAILED;
						
                        #if ( DEF_USE_USBX == 0x01 )
                        if( ( RootHubDev[ index ].bSpeed ) && ( ( PCx_Dev3_Status & BIT_DEV3_IS_PASS ) == 0 ) )
                        {
                            goto PASS_THROUGH;
                        }
                        #endif
					}
					break;
				}
			}
			else if( s >= ROOT_DEV_CONNECTED ) 
			{  
				/* ⵽豸γ */
				printf( "H%d Out\n", (UINT16)index );
                 
            #if ( DEF_USE_USBX == 0x01 )
				if( RootHubDev[ index ].DeviceIndex == 3 ) 
				{ 
					/* ֱͨ豸 */
                #if ( DEF_USE_USBX == 0x01 )
					if( PCx_Dev3_Status & BIT_DEV3_PC_RESET )
					{
						/* ǰڸλ豸 */
					}
					else
                #endif        
					{
						EA = 0;  												/* رж */
						USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | PCx_PassUSB_ActionNum;  
						if( USBH_ResetTimer || ( USB_CTRL & bUC_THROUGH ) || ( PCx_Dev3_Status & BIT_DEV3_IS_PASS ) ) 
						{  
							/* ڸλѾ */
							USBH_ResetTimer = 0;
							USB_CTRL &= ~bUC_THROUGH;  							/* USBֱֹͨ */
							USBX_ThisHub_EP1IntUp( 0x01 << ( 3 + 1 ) );  		/* ΪǰUSBXϴHUBж֪ͨ */	
						}
 						PCx_Dev3_Status = 0x00;  								/* ֱͨ豸Ƴ */
//						X0DevBitFlag[ 3 ] = 0x00;  								/* ˿ڿ */
						X0DevBitFlag[ 3 ] = BIT_PORT_C_CONN;
						USBX_SEL = 0;
						EA = 1;

						/* ز */
						RootHubDev[ index ].DeviceIndex = 0xFF;
						RootHubDev[ index ].bStatus = 0x00;
						USBH_DisableRootHubPort( index );  						/* رն˿ */
					}
				}
				else
            #endif
				{
                    #if ( DEF_USE_USBX == 0x01 )
                        /* ڹرжϺΪUSBXϴHUBж֪ͨ */
						USBX_AllHub_EP1IntUp( RootHubDev[ index ].DeviceIndex, BIT_PORT_C_CONN );
                        
                        /* ӦDevXĲ */
                        PCx_DevX_Status[ RootHubDev[ index ].DeviceIndex ] = 0x00;
                    #endif
	
						/* ز */
						RootHubDev[ index ].DeviceIndex = 0xFF;
						RootHubDev[ index ].bStatus = 0x00;		
						USBH_DisableRootHubPort( index );  						/* رն˿ */
				}

				/* 豸γ,³ʼUSB */
				if( ( RootHubDev[ 0 ].bStatus == 0x00 ) && ( RootHubDev[ 1 ].bStatus == 0x00 ) &&
				    ( RootHubDev[ 2 ].bStatus == 0x00 ) && ( RootHubDev[ 3 ].bStatus == 0x00 ) )
				{
					USBH_Init( );
                    
					USBD_Desc[ 0 ].Base_Offset = 0x00;
					USBD_Desc[ 0 ].Desc_Total = 0x00;
					USBD_Desc[ 1 ].Base_Offset = 0x00;
					USBD_Desc[ 1 ].Desc_Total = 0x00;
                    USBD_Desc[ 2 ].Base_Offset = 0x00;
					USBD_Desc[ 2 ].Desc_Total = 0x00;										 
				}
			}
		}
	}
    
	/**********************************************/
	/* ȡUSB豸˵ */
	for( num = 0; num < TOTAL_ROOT_HUB; num++ )
	{
		/* жǷҪUSB豸Xݻȡ */ 
		if( ( RootHubDev[ num ].bStatus >= ROOT_DEV_SUCCESS ) &&
            ( RootHubDev[ num ].bType == USB_DEV_CLASS_HID )
#if ( DEF_USE_USBX == 0x01 ) 
            && ( RootHubDev[ num ].DeviceIndex != 3 ) 
#endif
          )
		{	   
            for( i = 0; i < HostCtl[ num ].InterfaceNum; i++ )
            {
                for( j = 0; j < HostCtl[ num ].Interface[ i ].InEndpNum; j++ )			
                {
                    /* õѯʱȡ */	
                    if( HostCtl[ num ].Interface[ i ].InEndpTimeCount[ j ] >= HostCtl[ num ].Interface[ i ].InEndpInterval[ j ] )
                    {
                        HostCtl[ num ].Interface[ i ].InEndpTimeCount[ j ] %= HostCtl[ num ].Interface[ i ].InEndpInterval[ j ];
                            
                        /* ѡָROOT-HUB˿ */ 
                        USBH_SelectHubPort( num );  
                        
                        /* ȡ˵ */
                        status = USBH_Get_HidData( num, i, j, Com_Buf, &len ); 
                                        
                        /* ȡ˵һ */  
                        if( status == ERR_SUCCESS )
                        {
                            #if ( DEF_USE_USBX == 0x01 ) 
                            /* ǰʹܵPC˿ڷ */									
                            if( PCx_Connect_CurStatus & ( 1 << PCx_ActionNum ) )
                            {
                                USBX_Endpx_UpData( PCx_ActionNum, RootHubDev[ num ].DeviceIndex, HostCtl[ num ].Interface[ i ].InEndpAddr[ j ], Com_Buf, len );	
                            }
                            #else
                            printf("Hid Data:\n");
                            for( dev_num = 0; dev_num < len; dev_num++ )
                            {
                                printf("%x ",(UINT16)Com_Buf[ dev_num ]);
                            }
                            printf("\n");
                            #endif
                        }
                    }
                }
            }		
		}
	}
    
#if ( DEF_USE_USBX == 0x01 )
	/* USB̵ƴ */
	if( PCx_KBSetReport[ PCx_ActionNum ] != HID_SetReport_Last )
	{
		/* USB̷Set Report,LEDƿ */
		HID_SetReport_Last = PCx_KBSetReport[ PCx_ActionNum ];	
		
		/* ִпƴе */		
		KM_HostSetReport( PCx_KBSetReport[ PCx_ActionNum ] );

	}
	else if( Sp_SetReport_Len & 0x80 )
	{
		/* SetReportת */
		Sp_SetReport_Len &= 0x7F;

		/* ѡָROOT-HUB˿ */
		num = ( Sp_SetReport_Index >> 4 ) & 0x0F; 
		USBH_SelectHubPort( num );  		
		
		/* SetReport */
		HID_Sp_SetReport( Sp_SetReport_Pack, Sp_SetReport_Value, Sp_SetReport_Len, ( Sp_SetReport_Index & 0x0F ) );		
	}

	/* HUB豸֪ͨ(ֿԱ΢ʱ,ͬ1) */
	if( PCx_UpInt_TimeCount >= 100 )
	{
		PCx_UpInt_TimeCount = 0x00;
		for( i = 0; i < PCx_NumMax; i++ )
		{	
			if( PCx_TaskStatus[ i ] )
			{	
                if( PCx_TaskStatus[ i ] & 0x01 )
				{
					status = USBX_OneHub_EP1IntUp( i, 0, BIT_PORT_CONNECT | BIT_PORT_C_CONN );
					if( status == 0 )
					{
						PCx_TaskStatus[ i ] &= ~0x01;
						break;
					}			
				}
				else if( PCx_TaskStatus[ i ] & 0x02 )
				{				
					status = USBX_OneHub_EP1IntUp( i, 1, BIT_PORT_CONNECT | BIT_PORT_C_CONN );
					if( status == 0 )
					{
						PCx_TaskStatus[ i ] &= ~0x02;
						break;
					}		
				}				
				else if( PCx_TaskStatus[ i ] & 0x04 )
				{					
					status = USBX_OneHub_EP1IntUp( i, 2, BIT_PORT_CONNECT | BIT_PORT_C_CONN );
					if( status == 0 )
					{
						PCx_TaskStatus[ i ] &= ~0x04;
						break;
					}			
				}
				else if( PCx_TaskStatus[ i ] & 0x08 )
				{				
					status = USBX_OneHub_EP1IntUp( i, 3, BIT_PORT_CONNECT | BIT_PORT_C_CONN );
					if( status == 0 )
					{
						PCx_TaskStatus[ i ] &= ~0x08;
						break;
					}			
				}
				
				/* ǰϱ,ӿлһ̨ϱ */
				if( PCx_TaskStatus[ i ] == 0 )
				{
					PCx_UpInt_TimeCount = 50;
				}
			}											
		}
	}
#endif
    
	return( 0x00 );		
}